<?php
/**
 * Plugin Name: GistMag Blog Meta Generator
 * Plugin URI: https://gistmag.co.uk/wordpress-plugin/gistmag-blog-generator
 * Description: Generate images, excerpt, category, and tags for blog posts using AI
 * Version: 1.0.0
 * Author: GistMag
 * Author URI: https://gistmag.co.uk
 * License: GPL v2 or later
 * Text Domain: gistmag-blog-generator
 */

if (!defined('ABSPATH')) {
    exit;
}

define('GISTMAG_BLOG_GENERATOR_VERSION', '1.0.0');
define('GISTMAG_BLOG_GENERATOR_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('GISTMAG_BLOG_GENERATOR_PLUGIN_URL', plugin_dir_url(__FILE__));
define('GISTMAG_BLOG_GENERATOR_API_BASE_URL', 'https://api.gistmag.co.uk');

require_once GISTMAG_BLOG_GENERATOR_PLUGIN_DIR . 'includes/class-gistmag-blog-generator.php';
require_once GISTMAG_BLOG_GENERATOR_PLUGIN_DIR . 'includes/class-gistmag-blog-generator-api.php';
require_once GISTMAG_BLOG_GENERATOR_PLUGIN_DIR . 'includes/class-gistmag-blog-generator-admin.php';

function gistmag_blog_generator_init() {
    $plugin = new GistMag_Blog_Generator();
    $plugin->run();
    
    // Initialize admin class
    if (is_admin()) {
        new GistMag_Blog_Generator_Admin();
    }
}
add_action('plugins_loaded', 'gistmag_blog_generator_init');

register_activation_hook(__FILE__, 'gistmag_blog_generator_activate');
register_deactivation_hook(__FILE__, 'gistmag_blog_generator_deactivate');

function gistmag_blog_generator_activate() {
    // Set default options
    add_option('gistmag_blog_generator_api_key', '');
    add_option('gistmag_blog_generator_enabled', true);
    add_option('gistmag_blog_generator_default_image_style', 'realistic');
    add_option('gistmag_blog_generator_auto_apply', false);
}

function gistmag_blog_generator_deactivate() {
    // Cleanup if needed
}

