# GistMag TTS Reader WordPress Plugin

A WordPress plugin that adds text-to-speech functionality to your blog posts, allowing visitors to listen to your content instead of reading it.

## Features

- 🎙️ **Streaming TTS**: Real-time audio streaming for blog posts
- ⚡ **Fast Loading**: Audio starts playing as soon as it's generated
- 🎚️ **Customizable**: Control language, voice, and speed
- 📱 **Responsive**: Works on desktop and mobile devices
- 🌙 **Dark Mode**: Automatic dark mode support
- 🔧 **Easy Setup**: Simple configuration in WordPress admin

## Installation

1. Download the plugin folder
2. Upload the `gistmag-tts-reader` folder to `/wp-content/plugins/`
3. Activate the plugin through the 'Plugins' menu in WordPress
4. Go to Settings > TTS Reader to configure your API key

## Configuration

1. **Get Your API Key**: 
   - Sign up at [GistMag](https://gistmag.co.uk)
   - Go to your dashboard and copy your API key

2. **Configure Settings**:
   - Navigate to Settings > TTS Reader
   - Enter your API key
   - Choose your preferred language, voice, and speed
   - Select where to display the player (top or bottom of posts)

## Usage

### Automatic Display
The TTS player will automatically appear on all blog posts (if enabled in settings).

### Manual Placement
You can also manually place the player anywhere using the shortcode:

```
[gistmag_tts]
```

### Customization
- **Language**: Choose from English, Spanish, French, German, Italian, Portuguese, Japanese, Korean, or Chinese
- **Voice**: Leave empty for auto-selection, or specify a voice name (e.g., `en-US-Wavenet-D`)
- **Speed**: Adjust playback speed from 0.25x to 4.0x
- **Position**: Display at the top or bottom of posts

## API Integration

This plugin uses the GistMag TTS API:
- **Base URL**: `https://api.gistmag.co.uk`
- **Endpoint**: `/tts/stream`
- **Source**: `wordpress`

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- Active GistMag account with API key
- jQuery (included with WordPress)

## Credits

This plugin uses the GistMag Text-to-Speech API for audio generation.

## Support

For support, visit [GistMag Support](https://gistmag.co.uk/support) or check the [documentation](https://gistmag.co.uk/docs).

## License

GPL v2 or later

