<?php
/**
 * Plugin Name: GistMag TTS Reader
 * Plugin URI: https://gistmag.co.uk/wordpress-plugin/gistmag-tts-reader
 * Description: Stream text-to-speech audio for blog posts, allowing visitors to listen to your content
 * Version: 1.0.0
 * Author: GistMag
 * Author URI: https://gistmag.co.uk
 * License: GPL v2 or later
 * Text Domain: gistmag-tts-reader
 */

if (!defined('ABSPATH')) {
    exit;
}

define('GISTMAG_TTS_READER_VERSION', '1.0.0');
define('GISTMAG_TTS_READER_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('GISTMAG_TTS_READER_PLUGIN_URL', plugin_dir_url(__FILE__));
define('GISTMAG_TTS_READER_API_BASE_URL', 'https://api.gistmag.co.uk');

require_once GISTMAG_TTS_READER_PLUGIN_DIR . 'includes/class-gistmag-tts-reader.php';
require_once GISTMAG_TTS_READER_PLUGIN_DIR . 'includes/class-gistmag-tts-reader-api.php';
require_once GISTMAG_TTS_READER_PLUGIN_DIR . 'includes/class-gistmag-tts-reader-admin.php';

function gistmag_tts_reader_init() {
    $plugin = new GistMag_TTS_Reader();
    $plugin->run();
    
    // Initialize admin class
    if (is_admin()) {
        new GistMag_TTS_Reader_Admin();
    }
}
add_action('plugins_loaded', 'gistmag_tts_reader_init');

register_activation_hook(__FILE__, 'gistmag_tts_reader_activate');
register_deactivation_hook(__FILE__, 'gistmag_tts_reader_deactivate');

function gistmag_tts_reader_activate() {
    // Set default options
    add_option('gistmag_tts_reader_api_key', '');
    add_option('gistmag_tts_reader_enabled', true);
    add_option('gistmag_tts_reader_language', 'en');
    add_option('gistmag_tts_reader_voice_name', '');
    add_option('gistmag_tts_reader_speed', 1.0);
    add_option('gistmag_tts_reader_auto_show', true);
    add_option('gistmag_tts_reader_position', 'top'); // top or bottom
    add_option('gistmag_tts_reader_player_type', 'full'); // full or simple
    add_option('gistmag_tts_reader_display_on', 'both'); // posts, pages, or both
}

function gistmag_tts_reader_deactivate() {
    // Cleanup if needed
}

